/**
 * package:		Part of vpl-jail-system
 * copyright:	Copyright (C) 2009 Juan Carlos Rodríguez-del-Pino. All rights reserved.
 * license:		GNU/GPL, see LICENSE.txt or http://www.gnu.org/licenses/gpl-3.0.html
 **/
#include "util.h"
#include "vplregex.h"
#include "configurationFile.h"
#include "httpServer.h"
#include <fstream>
using namespace std;
void ConfigurationFile::parseConfigLine(ConfigData &data,const string &line){
	static const vplregex reg("^[ \t]*([^ \t]+)[ \t]*=[ \t]*([^#]*)");
	static const vplregex comment("^[ \t]*(#.*)?$");
	vplregmatch found(3);
	if(!comment.search(line, found)){
		if (reg.search(line, found)) {
			string param = found[1];
			string value = found[2];
			param = Util::toUppercase(param);
			Util::trimAndRemoveQuotes(value);
			if (data.find(param) != data.end()) {
				Logger::log(LOG_ERR,"Warning: Repeated config param %s=%s (Using last)", param.c_str(), value.c_str());
			}
			data[param] = value;
			Logger::log(LOG_INFO, "Read config param %s=%s", param.c_str(), value.c_str());
		} else {
			throw HttpException(internalServerErrorCode
					,"Incorrect config file: " + line);
		}
	}
}

ConfigData ConfigurationFile::readConfiguration(string fileName, ConfigData defaultData){
	ConfigData data;
	ifstream file;
	file.open(fileName.c_str(),ifstream::in);
	if(file.fail())
		throw HttpException(internalServerErrorCode
				,"Config file can't be opened",fileName);
	while(!file.fail()) {
		string line;
		getline(file,line);
		if(file.fail()) break;
		parseConfigLine(data,line);
	}
	for(ConfigData::iterator i = defaultData.begin(); i != defaultData.end(); i++) {
		string param = i->first;
		param = Util::toUppercase(param);
		if(data.find(param) == data.end())
			data[param] = i->second;
	}
	return data;
}

void ConfigurationFile::writeConfiguration(string fileName, ConfigData data){
	ofstream file;
	file.open(fileName.c_str(), ifstream::out);
	if(file.fail())
		throw HttpException(internalServerErrorCode,
				"Config file can't be write", fileName);
	chmod(fileName.c_str(), S_IRUSR|S_IWUSR);
	file << "#Autogenerated Config file of VPL " << endl;
	for(ConfigData::iterator i = data.begin(); i != data.end(); i++){
		string line=i->first + "=" + i->second;
		file << line << endl;
	}
	file << "#End Config file of VPL " << endl;
	file.close();
}
