define("mod_vpl/vplutil",["exports","jquery","core/log","core/url"],(function(_exports,_jquery,_log,_url){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Tools for the VPL IDE
   *
   * @copyright 2016 Juan Carlos Rodríguez-del-Pino
   * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   * @author Juan Carlos Rodríguez-del-Pino <jcrodriguez@dis.ulpgc.es>
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.syntaxHighlightFile=_exports.syntaxHighlight=_exports.init=_exports.addResults=_exports.VPLUtil=void 0,_jquery=_interopRequireDefault(_jquery),_log=_interopRequireDefault(_log),_url=_interopRequireDefault(_url);var VPLUtil={};_exports.VPLUtil=VPLUtil,VPLUtil.doNothing=_jquery.default.noop,VPLUtil.returnFalse=function(){return!1},VPLUtil.returnTrue=function(){return!0};var fileUniqueId,MIME,maplang,mapname,i18n,strreg,lastProccessID,scriptsLoaded,debugMode=!1;VPLUtil.log=function(m,forced){(debugMode||forced)&&_log.default.debug(m)},VPLUtil.setUserPreferences=function(pref){_jquery.default.ajax({async:!0,type:"POST",url:_url.default.relativeUrl("/mod/vpl/editor/userpreferences.json.php"),data:JSON.stringify(pref),contentType:"application/json; charset=utf-8",dataType:"json"})},VPLUtil.getUserPreferences=function(func){_jquery.default.ajax({async:!0,type:"POST",url:_url.default.relativeUrl("/mod/vpl/editor/userpreferences.json.php"),data:JSON.stringify({getPreferences:!0}),contentType:"application/json; charset=utf-8",dataType:"json"}).done(func)},VPLUtil.sanitizeHTML=function(t){return void 0===t||""==t.replace(/^\s+$/g,"")?"":(0,_jquery.default)("<div>"+t+"</div>").html()},VPLUtil.sanitizeText=function(s){return void 0===s||""==s.replace(/^\s+$/g,"")?"":s.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#39;")},VPLUtil.setProtocol=function(coninfo){var secure;if(0==coninfo.securePort||0==coninfo.port)secure=0==coninfo.port;else switch(coninfo.wsProtocol){case"always_use_wss":secure=!0;break;case"always_use_ws":secure=!1;break;default:secure="https:"==window.location.protocol}var URLBase=(secure?"wss://":"ws://")+coninfo.server;coninfo.secure=secure,coninfo.portToUse=secure?coninfo.securePort:coninfo.port,URLBase+=":"+coninfo.portToUse+"/",coninfo.monitorURL=URLBase+coninfo.monitorPath,coninfo.executionURL=URLBase+coninfo.executionPath},VPLUtil.ArrayBuffer2String=function(data){var i,len,view=new Uint8Array(data),chunks=[];for(i=0,len=view.length;i<len;i+=32e3)chunks.push(String.fromCharCode.apply(String,view.subarray(i,Math.min(i+32e3,len))));return chunks.join("")},VPLUtil.String2ArrayBuffer=function(data){for(var len=data.length,ret=new ArrayBuffer(len),u8=new Uint8Array(ret),i=0;i<len;i++)u8[i]=data.charCodeAt(i);return ret},fileUniqueId=0,VPLUtil.getUniqueId=function(){return fileUniqueId++},function(){var regExt=/\.([^.]*)$/,regImg=/^(gif|jpg|jpeg|png|ico)$/i,regAudio=/^(wav|aiff|pcm|mp3|aac|ogg|oga|wma|m4a|flac|alac|ape|wv|amr)$/i,regVideo=/^(mp4|webm|ogv|avi|mov|wmv|flv|mkv|m4v|mpeg|mpg|3gp)$/i,regBin=/^(zip|jar|pdf|tar|bin|7z|arj|deb|gzip|rar|rpm|dat|db|dll|rtf|doc|docx|odt|exe|com)$/i,regBlk=/^blockly[0123]?$/;VPLUtil.fileExtension=function(fileName){var res=regExt.exec(fileName);return null!==res?res[1]:""},VPLUtil.isImage=function(fileName){return regImg.test(VPLUtil.fileExtension(fileName))},VPLUtil.isAudio=function(fileName){return regAudio.test(VPLUtil.fileExtension(fileName))},VPLUtil.isVideo=function(fileName){return regVideo.test(VPLUtil.fileExtension(fileName))},VPLUtil.isBinary=function(fileName,fileContents){if(VPLUtil.isImage(fileName)||VPLUtil.isAudio(fileName)||VPLUtil.isVideo(fileName)||regBin.test(VPLUtil.fileExtension(fileName)))return!0;if(void 0===fileContents||!fileContents)return!1;var textBytes=[7,8,9,10,12,13,27].concat([...Array(95).keys()].map((i=>i+32))).concat([...Array(128).keys()].map((i=>i+128)));textBytes=Object.entries(textBytes).reduce(((obj,_ref)=>{let[key,value]=_ref;return{...obj,[value]:key}}),{});var bytes=null;if(fileContents instanceof Uint8Array)bytes=fileContents;else if(fileContents instanceof ArrayBuffer)bytes=new Uint8Array(fileContents);else{if(!(fileContents instanceof String||"string"==typeof fileContents))return!1;bytes=(new TextEncoder).encode(fileContents.substring(0,512))}for(var sizechecked=Math.min(1024,bytes.length),i=0;i<sizechecked;i++)if(!textBytes.hasOwnProperty(bytes[i]))return!0;return!1},VPLUtil.isBlockly=function(fileName){return regBlk.test(VPLUtil.fileExtension(fileName))};var regInvalidFileName=/[\cA-\cZ]|[:-@]|[{-~]|\\|\[|\]|[/^`´]|^-|^ | $|\.\./;VPLUtil.validFileName=function(fileName){return!(fileName.length<1)&&(!(fileName.length>128)&&!regInvalidFileName.test(fileName))}}(),VPLUtil.getCurrentTime=function(){return parseInt((new Date).valueOf()/1e3)},VPLUtil.validPath=function(path){if(path.length>256)return!1;for(var dirs=path.split("/"),i=0;i<dirs.length;i++)if(!VPLUtil.validFileName(dirs[i]))return!1;return!0},VPLUtil.getFileName=function(path){var dirs=path.split("/");return dirs[dirs.length-1]},VPLUtil.dataFromURLData=function(data){return data.substring(data.indexOf(",")+1)},MIME={gif:"image/gif",jpg:"image/jpeg",jpeg:"image/jpeg",png:"image/png",ico:"image/vnd.microsoft.icon",pdf:"application/pdf",wav:"audio/wav",aiff:"audio/aiff",pcm:"audio/pcm",mp3:"audio/mpeg",aac:"audio/aac",oga:"audio/ogg",ogg:"audio/ogg",wma:"audio/x-ms-wma",m4a:"audio/mp4",flac:"audio/flac",alac:"audio/alac",ape:"audio/x-ape",wv:"audio/x-wavpack",amr:"audio/amr",mp4:"video/mp4",webm:"video/webm",ogv:"video/ogg",avi:"video/x-msvideo",mov:"video/quicktime",wmv:"video/x-ms-wmv",flv:"video/x-flv",mkv:"video/x-matroska",m4v:"video/x-m4v",mpeg:"video/mpeg",mpg:"video/mpeg","3gp":"video/3gpp"},VPLUtil.getMIME=function(fileName){var ext=VPLUtil.fileExtension(fileName);return ext in MIME?MIME[ext]:"application/octet-stream"},VPLUtil.getTimeLeft=function(timeLeft){var res="";timeLeft<0&&(res+="-",timeLeft=-timeLeft);var timePending=timeLeft,days=parseInt(timePending/86400);timePending-=86400*days,0!==days&&(res+=days+"T");var hours=parseInt(timePending/3600);timePending-=3600*hours;var minutes=parseInt(timePending/60);timePending-=60*minutes;var seconds=parseInt(timePending);return res+=("00"+hours).slice(-2)+":",res+=("00"+minutes).slice(-2),timeLeft<3600&&(res+=":"+("00"+seconds).slice(-2)),res},maplang={Abap:"abap",ABC:"abc",Ada:"ada",ActionScript:"actionscript","x86 assembly":"assembly_x86",Bash:"sh",Batch:"batchfile",C:"c_cpp","C++":"c_cpp","VPL cases":"cases",Cobol:"cobol",CoffeeScript:"coffee",Clojure:"clojure","C#":"csharp","C# project":"xml",CSS:"css",D:"d",Dart:"dart",Eiffel:"eiffel",Erlang:"erlang","F#":"fsharp","F# project":"xml",Fortran:"fortran",Go:"golang",Groovy:"groovy",Dot:"dot",Haskell:"haskell",HTML:"html",Haxe:"haxe",Java:"java",Julia:"julia",JavaScript:"javascript",JSON:"json",JSP:"jsp",JSX:"jsx",OCaml:"ocaml",Kotlin:"kotlin",Makefile:"makefile",Matlab:"matlab",Markdown:"markdown",LaTeX:"latex",Less:"less",LISP:"lisp",Lua:"lua",Pascal:"pascal",Perl:"perl",PHP:"php","Plain text":"plain_text",Prolog:"prolog",PSeInt:"pseint",Python:"python",R:"r",reStructuredText:"rst",Ruby:"ruby",Rust:"rust",SASS:"sass",Scala:"scala",Scheme:"scheme",SCSS:"scss","Bash/shell":"sh",Swift:"swift",SQL:"sql",SVG:"svg",TeX:"tex",tcl:"tcl",TypeScript:"typescript",Twig:"twig",VBScript:"vbscript",Verilog:"verilog",VisualBasic:"vbscript","VisualBasic project":"xml",VHDL:"vhdl",XML:"xml",Yaml:"yaml"},mapname={abap:"Abap",abc:"ABC",ada:"Ada",ads:"Ada",adb:"Ada",as:"ActionScript",as3:"ActionScript",asm:"x86 assembly",bash:"Bash",bat:"Batch",c:"C",C:"C++",cc:"C++",cpp:"C++","c++":"C++",hxx:"C++",h:"C",H:"C++",cases:"VPL cases",cbl:"Cobol",cob:"Cobol",coffee:"CoffeeScript",clj:"Clojure",cs:"C#",csproj:"C# project",css:"CSS",d:"D",dart:"Dart",e:"Eiffel",erl:"Erlang",hrl:"Erlang",f:"Fortran",f77:"Fortran",f90:"Fortran",for:"Fortran",fs:"F#",fsproj:"F# project",go:"Go",groovy:"Groovy",gv:"Dot",hs:"Haskell",htm:"HTML",html:"HTML",hx:"Haxe",java:"Java",jl:"Julia",js:"JavaScript",json:"JSON",jsp:"JSP",jsx:"JSX",kt:"Kotlin",kts:"Kotlin",m:"Matlab",md:"Markdown",ml:"OCaml",mli:"OCaml",latex:"LaTeX",less:"Less",lisp:"LISP",lsp:"LISP",lua:"Lua",pas:"Pascal",p:"Pascal",perl:"Perl",prl:"Perl",php:"PHP",pro:"Prolog",pl:"Prolog",psc:"pseint",py:"Python",R:"R",r:"R",rb:"Ruby",ruby:"Ruby",rs:"Rust",rst:"reStructuredText",s:"x86 assembly",sass:"SASS",scala:"Scala",scm:"Scheme",scss:"SCSS",sh:"Bash/shell",swift:"Swift",sql:"SQL",svg:"SVG",tex:"TeX",tcl:"TCL",ts:"TypeScript",twig:"Twig",vb:"VisualBasic",vbproj:"VisualBasic project",vbs:"VBSscript",v:"Verilog",vh:"Verilog",vhd:"VHDL",vhdl:"VHDL",xml:"XML",yaml:"YAML",".makefile":"Makefile",".Makefile":"Makefile"},VPLUtil.getLangNames=function(){return Object.assign({},mapname)},VPLUtil.langType=function(filenamepath){var ext=VPLUtil.fileExtension(filenamepath);if(ext in mapname)return maplang[mapname[ext]];var extfile="."+VPLUtil.getFileName(filenamepath);return extfile in mapname?maplang[mapname[extfile]]:"plain_text"},VPLUtil.langName=function(filenamepath){var ext=VPLUtil.fileExtension(filenamepath);if(ext in mapname)return mapname[ext];var extfile="."+VPLUtil.getFileName(filenamepath);return extfile in mapname?mapname[extfile]:"Plain text"},VPLUtil.useHardTabs=function(filenamepath){var type=VPLUtil.langType(filenamepath);return"makefile"==type||"golang"==type},i18n={},strreg=/\{\\*\$a\\*}/g,VPLUtil.str=function(key,parm){return i18n[key]?void 0!==parm?i18n[key].replace(strreg,parm):i18n[key]:"{"+key+"}"},VPLUtil.setStr=function(newi18n){for(var key in newi18n)newi18n.hasOwnProperty(key)&&(i18n[key]=newi18n[key])},VPLUtil.setStr(window.VPLi18n),function(){var delayedActions={},afterAllActions={},numberDelayed=0,internalDelay=function(timeout,id,func,arg1,arg2){void 0!==delayedActions[id]&&(clearTimeout(delayedActions[id]),numberDelayed--),numberDelayed++,delayedActions[id]=setTimeout((function(){numberDelayed--,func(arg1,arg2),delete delayedActions[id]}),timeout)};VPLUtil.delay=function(id,func,arg1,arg2){internalDelay(20,id,func,arg1,arg2)},VPLUtil.longDelay=function(id,func,arg1,arg2){internalDelay(100,id,func,arg1,arg2)};var setAfterTimeout=function(id,func,arg1,arg2){void 0!==afterAllActions[id]&&clearTimeout(afterAllActions[id]),afterAllActions[id]=setTimeout((function(){numberDelayed>0?afterAllActions[id]=setAfterTimeout(id,func,arg1,arg2):(func(arg1,arg2),delete afterAllActions[id])}),100)};VPLUtil.afterAll=function(id,func,arg1,arg2){setAfterTimeout(id,func,arg1,arg2)}}(),VPLUtil.supportWebSocket=function(){return"WebSocket"in window},VPLUtil.isAndroid=function(){return window.navigator.userAgent.indexOf("Android")>-1},VPLUtil.isFirefox=function(){return window.navigator.userAgent.indexOf("Firefox")>-1},VPLUtil.isMac=function(){return window.navigator.userAgent.indexOf("Mac")>-1},lastProccessID=-1,VPLUtil.setProcessId=function(id){lastProccessID=id},VPLUtil.getProcessId=function(){return lastProccessID},VPLUtil.directRun=function(URL,command,files){var deferred=_jquery.default.Deferred();return _jquery.default.ajax({async:!0,type:"POST",url:URL+"directrun",data:JSON.stringify({command:command,files:files}),contentType:"application/json; charset=utf-8",dataType:"json"}).done((function(result){if(result.success){var response=result.response;VPLUtil.setProtocol(response);var ws=new WebSocket(response.executionURL);_log.default.debug("Conecting with:"+response.executionURL),deferred.resolve({processid:response.processid,homepath:response.homepath,connection:ws})}else deferred.reject(result.error)})).fail((function(jqXHR,textStatus,errorThrown){var message="Connection fail: "+textStatus;null!=errorThrown.message&&(message+=": "+errorThrown.message),_log.default.debug(message),deferred.reject(message)})),deferred},VPLUtil.directRunTest=function(URL,command,data){VPLUtil.directRun(URL,command,[{name:"a.c",contents:"int main(){return 0;}",encoding:0},{name:"b.c",contents:"int f(){return 1;}",encoding:0}]).done((function(result){var mcount=0;result.connection.onopen=function(){_log.default.debug("Ws open "+result.homepath+" processid "+result.processid),null!=data&&result.connection.send(data),setTimeout((function(){result.connection.close()}),6e5)},result.connection.onmessage=function(event){_log.default.debug("WS Message ("+ ++mcount+"): "+event.data),mcount>=10&&result.connection.close()},result.connection.onerror=function(event){_log.default.debug("WS error: "+event)},result.connection.onclose=function(event){_log.default.debug("WS close: "+event.code+" "+event.reason)}})).fail((function(message){_log.default.debug("Direct run fail. URL: "+URL+" command: "+command+" message: "+message)}))},VPLUtil.processResult=function(text,filenames,sh,noFormat,addLinks,folding){if(void 0===text||""==text.replace(/^\s+$/gm,""))return"";function escReg(t){return t.replace(/[-[\]{}()*+?.,\\^$|#\s]/,"\\$&")}var regtitgra=/\([-]?[\d]+[.]?[\d]*\)\s*$/,regtit=/^-/,regcas=/^\s*>/,regError=new RegExp("\\[err\\]|error|"+escReg(VPLUtil.str("error")),"i"),regWarning=new RegExp("\\[warn\\]|warning|note|"+escReg(VPLUtil.str("warning")),"i"),regInformation=new RegExp("\\[info\\]|information","i"),state="",html="",comment="",case_="",lines=text.split(/\r\n|\n|\r/),regFiles=[],lastAnnotation=!1,lastAnnotationFile=!1,afterTitle=!1;function getHref(i){return void 0===sh[i].getTagId?'href="#" ':'href="#'+sh[i].getTagId()+'" '}function genFileLinks(line,rawline){if(!addLinks)return line;for(var used=!1,i=0;i<regFiles.length;i++)for(var match,reg=regFiles[i];null!==(match=reg.exec(line));){var type,anot=sh[i].getAnnotations();lastAnnotationFile=i,used=!0,type=line.search(regError)>-1?"error":line.search(regWarning)>-1?"warning":line.search(regInformation)>-1?"info":"error",lastAnnotation={row:match[3]-1,column:match[5],type:type,text:rawline},anot.push(lastAnnotation);var fileName=filenames[i],href=getHref(i),lt=VPLUtil.sanitizeText(fileName),data='data-file="'+fileName+'" data-line="'+match[3]+'"';line=line.replace(reg,"$1<a "+href+' class="vpl_fl" '+data+">"+lt+"$2$3$4$5$6</a>"),sh[i].setAnnotations(anot)}return!used&&lastAnnotation&&(""!==rawline?(lastAnnotation.text+="\n"+rawline,sh[lastAnnotationFile].setAnnotations(sh[lastAnnotationFile].getAnnotations())):lastAnnotation=!1),line}function getTitle(line){lastAnnotation=!1,line=line.substring(1);var end=regtitgra.exec(line);null!==end&&(line=line.substring(0,line.length-end[0].length));var html="";return folding&&(html+='<a href="javascript:void(0)" onclick="VPLUtil.showHideDiv(this)">[+]</a>'),html=genFileLinks(html+='<b class="ui-widget-header ui-corner-all">'+VPLUtil.sanitizeText(line)+"</b><br>",line)}function getComment(){lastAnnotation=!1;var ret=comment;return comment="",ret}function addComment(rawline){var line=VPLUtil.sanitizeText(rawline);comment+=genFileLinks(line,rawline)+"<br>"}function addCase(rawline){var line=VPLUtil.sanitizeText(rawline);case_+=genFileLinks(line,rawline)+"\n"}function getCase(){lastAnnotation=!1;var ret=case_;return case_="","<pre>"+ret+"</pre>"}!function(){for(var i=0;i<filenames.length;i++){var reg="(^| |/)"+escReg(filenames[i])+"( on line | line |:|\\()(\\d+)(:|,)?(\\d+)?(\\))?";regFiles[i]=new RegExp(reg,"m")}}();for(var i=0;i<lines.length;i++){var line=lines[i];if(noFormat)html+=genFileLinks(VPLUtil.sanitizeText(line),line)+"\n";else{var match=regcas.exec(line),regcasv=regcas.test(line);if(null!==match!=regcasv&&VPLUtil.log("error"),regtit.test(line)){switch(state){case"comment":html+=getComment();break;case"case":html+=getCase()}afterTitle&&(html+="</div>"),html+=getTitle(line),html+=folding?'<div style="display:none">':"<div>",afterTitle=!0,state=""}else regcasv?("comment"==state&&(html+=getComment()),addCase(line.substring(match[0].length)),state="case"):("case"==state&&(html+=getCase()),addComment(line),state="comment")}}switch(state){case"comment":html+=getComment();break;case"case":html+=getCase()}return afterTitle&&(html+="</div>"),html},scriptsLoaded=[],VPLUtil.loadScript=function(scripts,end){if(0!=scripts.length){var scriptURL=scripts[0];if(void 0===scriptsLoaded[scriptURL]){scripts.shift(),scriptsLoaded[scriptURL]=1;var script=document.createElement("script");script.type="text/javascript",script.src=VPLUtil.options.scriptPath+scriptURL,script.onload=function(){scriptsLoaded[scriptURL]=2,VPLUtil.loadScript(scripts,end)},document.head.appendChild(script)}else if(2==scriptsLoaded[scriptURL])scripts.shift(),VPLUtil.loadScript(scripts,end);else{var fullScriptPath=VPLUtil.options.scriptPath+scriptURL;VPLUtil.log("Loading js "+fullScriptPath+" (state "+scriptsLoaded[scriptURL]+")"),setTimeout((function(){VPLUtil.loadScript(scripts,end)}),50)}}else end()},VPLUtil.isScriptLoading=function(scriptURL){return void 0!==scriptsLoaded[scriptURL]&&1==scriptsLoaded[scriptURL]},VPLUtil.isScriptLoaded=function(scriptURL){return void 0!==scriptsLoaded[scriptURL]&&2==scriptsLoaded[scriptURL]},VPLUtil.loadModule=function(module,variable){return new Promise((function(resolve,reject){if(void 0!==window[variable])return VPLUtil.log("Module "+module+" already loaded"),void resolve(window[variable]);var ntimedout=0;var resolved=!1,moduleURL=_url.default.relativeUrl("/mod/vpl/thirdpartylibs/"+module+".js"),code="window."+variable+" = (await import('"+moduleURL+"')).default;",script=document.createElement("script");script.type="module",script.onload=()=>{VPLUtil.log("Module "+module+" loaded"),resolved||(resolved=!0,resolve(window[variable]))},script.onerror=()=>{VPLUtil.log("Module "+module+" failed to load"),resolved||(resolved=!0,reject())},script.innerHTML=code,document.head.appendChild(script),setTimeout((function checkLoaded(){resolved||(void 0!==window[variable]?(VPLUtil.log("Module "+module+" loaded after check "+250*ntimedout+"ms"),resolved=!0,resolve(window[variable])):ntimedout<40?(ntimedout++,setTimeout(checkLoaded,250)):(VPLUtil.log("Module "+module+" not loaded after check "+250*ntimedout+"ms"),resolved=!0,reject()))}),250)}))},function(){var files=[],results=[],shs=[],nFileGroupHighlighter=0;function FileGroupHighlighter(files,results){this.files=files,this.results=results,this.shFiles=[],this.shFileNames=[],this.fileGroupId=nFileGroupHighlighter,nFileGroupHighlighter++,this.highlight()}FileGroupHighlighter.prototype.highlightBlockly=function(preid){VPLUtil.loadScript(["/blockly/blockly_compressed.js","/blockly/msg/js/en.js","/blockly/blocks_compressed.js"],(function(){var tag=(0,_jquery.default)("#"+preid),c=tag.html();(0,_jquery.default)("#"+preid+"load").remove(),tag.html(""),tag.show(),c=(0,_jquery.default)("<div />").html(c).text().replace(/\n/g,"");var xml=Blockly.Xml.textToDom(c);tag.html("").height(300).width(tag.parent().width());var work=Blockly.inject(preid,{toolbox:"",readOnly:!0,media:"../editor/blockly/media/"});Blockly.Xml.domToWorkspace(xml,work);var hg=VPLUtil.adjustBlockly(work,10,10);tag.height(hg),tag.width("100%"),Blockly.svgResize(work),Blockly.resizeSvgContents(work);var h=tag.html();work.dispose(),tag.html(h)}))},FileGroupHighlighter.prototype.highlight=function(){var self=this,needAce=!1,files=this.files;for(let i=0;i<files.length;i++){let file=files[i];if(!VPLUtil.isBinary(file.fileName)&&!VPLUtil.isBlockly(file.fileName)){needAce=!0;break}}needAce&&"undefined"==typeof ace?VPLUtil.loadScript(["/../../thirdpartylibs/ace/ace.js"],(function(){self.highlight()})):VPLUtil.delay("FFGH."+self.fileGroupId,(function(){self.highlightStep(0)}))},FileGroupHighlighter.prototype.highlightStep=function(pos){if(pos>=this.files.length)return void this.resultStep(0);let file=this.files[pos],preid="code"+file.tagId;if(VPLUtil.isBlockly(file.fileName))this.highlightBlockly(preid);else{var lang=VPLUtil.langType(file.fileName);(0,_jquery.default)("#"+preid).show(),(0,_jquery.default)("#"+preid+"load").remove();var sh=ace.edit(preid);sh.setTheme("ace/theme/"+file.theme),sh.getSession().setMode("ace/mode/"+lang),sh.renderer.setShowGutter(file.showln),sh.setReadOnly(!0),sh.setHighlightActiveLine(!1),sh.setAutoScrollEditorIntoView(!0),sh.setOption("maxLines",file.nl),sh.getAnnotations=function(){return this.getSession().getAnnotations()},sh.cleanAnnotations=function(annotations){for(var counts={},res=[],i=0;i<annotations.length;i++){var annot=annotations[i];void 0===counts[annot.row]&&(counts[annot.row]=0),counts[annot.row]<5&&res.push(annot),counts[annot.row]++}return res},sh.setAnnotations=function(a){return this.getSession().setAnnotations(this.cleanAnnotations(a))},sh.getTagId=function(){return this.vplTagId},sh.vplTagId=file.tagId,this.shFiles.push(sh),this.shFileNames.push(file.fileName),shs[file.tagId]=sh}var self=this;VPLUtil.delay(preid+".next",(function(){self.highlightStep(pos+1)}))},FileGroupHighlighter.prototype.resultStep=function(pos){if(!(pos>=this.results.length)){var self=this,result=this.results[pos],tag=document.getElementById(result.tagId),text=tag.textContent||tag.innerText;tag.innerHTML=VPLUtil.processResult(text,this.shFileNames,this.shFiles,result.noFormat,result.addLinks,result.folding),VPLUtil.delay(result.tagId+".next",(function(){self.resultStep(pos+1)}))}},VPLUtil.addResults=function(tagId,noFormat,addLinks,folding){results.push({tagId:tagId,noFormat:noFormat,addLinks:addLinks,folding:folding})},VPLUtil.syntaxHighlightFile=function(tagId,fileName,theme,showln,nl){files.push({tagId:tagId,fileName:fileName,theme:theme,showln:showln,nl:nl})},VPLUtil.syntaxHighlight=function(){var groupFiles=files,groupResults=results;files=[],results=[],new FileGroupHighlighter(groupFiles,groupResults)},VPLUtil.flEventHandler=function(event){var tag=event.target.getAttribute("href").substring(1),line=event.target.getAttribute("data-line"),sh=shs[tag];sh.gotoLine(line,0),sh.scrollToLine(line,!0)},VPLUtil.setflEventHandler=function(){for(var links=document.getElementsByClassName("vpl_fl"),i=0;i<links.length;i++)links[i].onclick=VPLUtil.flEventHandler},VPLUtil.showHideDiv=function(a){var text=a,div=a;for(div.nextSibling||(div=div.parentNode),div=div.nextSibling;"DIV"!=div.nodeName&&"PRE"!=div.nodeName;)if(!(div=div.nextSibling))return;text&&("[+]"==text.innerHTML?(div.savedDisplay?div.style.display=div.savedDisplay:div.style.display="",text.innerHTML="[-]"):(div.savedDisplay=div.style.display,div.style.display="none",text.innerHTML="[+]"))},VPLUtil.adjustBlockly=function(work,offx,offy){for(var blocks=work.getAllBlocks(),miy=2e4,may=-2e4,mix=2e4,max=-2e4,i=0;i<blocks.length;i++){var xy=blocks[i].getRelativeToSurfaceXY();miy=Math.min(miy,xy.y),may=Math.max(may,xy.y),mix=Math.min(mix,xy.x),max=Math.max(max,xy.x)}blocks=work.getTopBlocks();for(var j=0;j<blocks.length;j++)blocks[j].moveBy(offx-mix,offy-miy);return may-miy+100+offy}}(),VPLUtil.options={scriptPath:""},void 0!==window.VPLDebugMode&&(debugMode=window.VPLDebugMode),VPLUtil.init=function(options){VPLUtil.options={scriptPath:""},_jquery.default.extend(VPLUtil.options,options),void 0!==window.VPLDebugMode&&(debugMode=window.VPLDebugMode),VPLUtil.log(VPLUtil.options)},self.VPLUtil=VPLUtil;const init=VPLUtil.init;_exports.init=init;const addResults=VPLUtil.addResults;_exports.addResults=addResults;const syntaxHighlightFile=VPLUtil.syntaxHighlightFile;_exports.syntaxHighlightFile=syntaxHighlightFile;const syntaxHighlight=VPLUtil.syntaxHighlight;_exports.syntaxHighlight=syntaxHighlight}));

//# sourceMappingURL=vplutil.min.js.map