define("mod_vpl/vplvnc",["exports","jquery","mod_vpl/vplutil","mod_vpl/vplui","mod_vpl/vplclipboard","core/log"],(function(_exports,_jquery,_vplutil,_vplui,_vplclipboard,_log){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * VNC client control
   *
   * @copyright 2014 Juan Carlos Rodríguez-del-Pino
   * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   * @author Juan Carlos Rodríguez-del-Pino <jcrodriguez@dis.ulpgc.es>
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.VPLVNCClient=void 0,_jquery=_interopRequireDefault(_jquery),_log=_interopRequireDefault(_log);_exports.VPLVNCClient=class{constructor(VNCDialogId,str){var rfb,clipboard,titleText,inputarea,self=this,title="",message="",lastState="disconnected",lastCanvas=null,VNCDialog=(0,_jquery.default)("#"+VNCDialogId),canvas=(0,_jquery.default)("#"+VNCDialogId+" div"),onCloseAction=_vplutil.VPLUtil.doNothing,needResize=!0;function receiveClipboard(event){_vplutil.VPLUtil.log("Receiving clipboard"),clipboard.setEntry1(event.detail.text)}function openClipboard(){clipboard.show()}function getFocus(){self.isConnected()}function lostFocus(){self.isConnected()}(inputarea=window.document.createElement("input")).style.position="absolute",inputarea.style.left="0px",inputarea.style.top="-10000px",inputarea.style.width="1em",inputarea.style.height="1ex",inputarea.style.opacity="0",inputarea.style.backgroundColor="transparent",inputarea.style.borderStyle="none",inputarea.style.outlineStyle="none",inputarea.autocapitalize="off",inputarea.autocomplete="off",inputarea.autocorrect="off",inputarea.wrap="off",inputarea.spellcheck="false",VNCDialog.append(inputarea);var HTMLUpdateClipboard=_vplui.VPLUI.genIcon("copy","sw")+" "+str("copy"),HTMLPaste=_vplui.VPLUI.genIcon("paste","sw")+" "+str("paste");function controlDialogSize(){var bw=(0,_jquery.default)("html").width(),bh=(0,_jquery.default)(window).height();VNCDialog.width()>bw&&(needResize=!0,VNCDialog.dialog("option","width",bw)),VNCDialog.parent().height()>bh&&(needResize=!0,VNCDialog.dialog("option","height",bh-VNCDialog.prev().outerHeight()))}function connectHandler(event){updateState("connected",event)}function disconnectHandler(event){self.saveLastCanvas(),updateState("disconnect",event)}function serververificationHandler(event){_vplutil.VPLUtil.log("VNC server verification "+event.detail.status)}function credentialsrequiredHandler(event){_vplutil.VPLUtil.log("VNC credentials required "+event.detail.status)}function securityfailureHandler(event){updateState("failed",event),_vplutil.VPLUtil.log("VNC security failure "+event.detail.status)}function clippingviewportHandler(event){_vplutil.VPLUtil.log("VNC clipping viewport "+event.detail.status)}function capabilitiesHandler(event){_vplutil.VPLUtil.log("VNC capabilities "+event.detail.status)}function desktopnameHandler(event){_vplutil.VPLUtil.log("VNC desktop name "+event.detail.status),self.setTitle(event.detail.name)}function updateState(newstate,event){switch(newstate){case"connected":lastState="connected",self.displayResize(),self.setMessage(""),self.setTitle(str("connected"));break;case"disconnect":case"disconnected":lastState="disconnected",self.setTitle(str("connection_closed")),self.restoreLastCanvas();break;case"failed":lastState="disconnected",self.setTitle(str("connection_fail")),_log.default.log("VNC client: "+event.detail.status);break;default:self.setMessage(""),self.setTitle(str("connecting"))}}function round(v){return v<100&&(v=100),2*Math.floor(v/2)}clipboard=new _vplclipboard.VPLClipboard("vpl_dialog_vnc_clipboard",HTMLUpdateClipboard,(function(){clipboard.setEntry1(clipboard.getEntry1()),document.execCommand("copy")}),HTMLPaste,(function(){if(_vplutil.VPLUtil.log("Pasting clipboard"),self.isConnected()){const text=clipboard.getEntry2();rfb.clipboardPasteFrom(text)}}),lostFocus),canvas.on("click",(function(e){e.target==canvas[0]?getFocus():lostFocus()})),this.displayResize=function(){var w=round(VNCDialog.width()),h=round(VNCDialog.parent().height()-VNCDialog.prev().outerHeight());self.setCanvasSize(w,h)},VNCDialog.dialog({closeOnEscape:!1,autoOpen:!1,modal:!0,width:"auto",height:"auto",classes:{"ui-dialog":"vpl_ide vpl_vnc"},create:function(){titleText=_vplui.VPLUI.setTitleBar(VNCDialog,"vnc","graphic",["clipboard","keyboard"],[openClipboard,getFocus])},dragStop:controlDialogSize,focus:getFocus,open:function(){self.restoreLastCanvas(),controlDialogSize()},beforeClose:function(){needResize&&(needResize=!1,self.displayResize())},close:function(){self.disconnect()},resizeStop:function(){controlDialogSize(),needResize=!0}}),VNCDialog.css("padding","1px"),VNCDialog.parent().css("z-index",2e3),this.updateTitle=function(){var text=title;""!==message&&(text+=" ("+message+")"),titleText.text(str("console")+": "+text)},this.setTitle=function(t){title=t,this.updateTitle()},this.setMessage=function(t){message=t,this.updateTitle()},this.saveLastCanvas=function(){self.isConnected()&&(lastCanvas=rfb.toDataURL())},this.restoreLastCanvas=function(){if(lastCanvas&&"disconnected"===lastState){var img=document.createElement("img");img.src=lastCanvas,img.style.width="100%",img.style.height="100%",canvas.html(""),canvas.append(img),lastCanvas=null}},this.connect=function(secure,host,port,password,path,onClose){_vplutil.VPLUtil.loadModule("noVNC/core/rfb","RFB").then((function(RFB){port||(port=secure?443:80),clipboard.setEntry1(""),onCloseAction=onClose,rfb&&("disconnected"!==lastState&&rfb.disconnect(),rfb=null),canvas.html(""),self.show(),lastState="connecting",self.setTitle(str("connecting"));var target=canvas[0];return(rfb=new RFB(target,(secure?"wss":"ws")+"://"+host+":"+port+"/"+path,{encrypt:secure,repeaterID:"",true_color:!0,local_cursor:!0,shared:!1,view_only:!1,credentials:{password:password}})).addEventListener("connect",connectHandler),rfb.addEventListener("disconnect",disconnectHandler),rfb.addEventListener("serververification",serververificationHandler),rfb.addEventListener("credentialsrequired",credentialsrequiredHandler),rfb.addEventListener("securityfailure",securityfailureHandler),rfb.addEventListener("clippingviewport",clippingviewportHandler),rfb.addEventListener("capabilities",capabilitiesHandler),rfb.addEventListener("clipboard",receiveClipboard),rfb.addEventListener("bell",(()=>_log.default.log("Bell received"))),rfb.addEventListener("desktopname",desktopnameHandler),rfb.clipViewport=!0,rfb.scaleViewport=!1,rfb.resizeSession=!0,rfb.qualityLevel=6,rfb.compressionLevel=2,rfb.showDotCursor=!0,!0})).catch((function(error){return _log.default.error("Failed to load RFB module:",error),self.setTitle(str("connection_fail")),self.show(),!1}))},this.isOpen=function(){return VNCDialog.dialog("isOpen")},this.close=function(){VNCDialog.dialog("close")},this.isConnected=function(){return rfb&&"disconnected"!=lastState},this.disconnect=function(){this.isConnected()&&(self.saveLastCanvas(),rfb.disconnect()),onCloseAction(),clipboard.hide()},this.getCanvasSize=function(){return canvas.width()+"x"+canvas.height()},this.setCanvasSize=function(w,h){w=round(w),h=round(h),canvas.width(w),canvas.height(h);var inner=canvas.find("canvas");inner.length>0&&(inner.width(w),inner.height(h))},this.show=function(){VNCDialog.dialog("open"),VNCDialog.width("auto"),VNCDialog.height("auto")},self.setCanvasSize((0,_jquery.default)(window).width()-150,(0,_jquery.default)(window).height()-150)}}}));

//# sourceMappingURL=vplvnc.min.js.map